var samplePageObj = {
  // 샘플 타이틀
  title: '셀 Drag & Drop',
  subtitle: '셀 데이터 드래그 & 드롭 이동',
  // 샘플 설명
  desc: '셀 데이터를 드래그 & 드롭으로 이동할 수 있습니다.'
  + '<br>onStartDragCell 이벤트에서 1(true)를 반환할 경우 드래그를 막을 수 있습니다.',

  // 객체 초기화 구문
  init: {
    Cfg: {
      CanEdit: 0,
      CanDrag: 1,
      DragCell: 1,
      CanSelect: 0,
      ColorState: 60,
      FitWidth: true
    },
    Def: {
      Row: {
        CanFormula: true
      }
    },
    Cols: [
      {
        Header: '1팀(고정)',
        Type: 'Img',
        Width: 200,
        Name: 'sImage1',
        Align: 'Center',
        Color: '#CDCDCD'
      },
      {
        Header: '2팀',
        Type: 'Img',
        Width: 200,
        Name: 'sImage2',
        Align: 'Center'
      },
      {
        Header: '3팀',
        Type: 'Img',
        Width: 200,
        Name: 'sImage3',
        Align: 'Center'
      },
      {
        Header: '4팀',
        Type: 'Img',
        Width: 200,
        Name: 'sImage4',
        Align: 'Center'
      },
      {
        Header: '5팀',
        Type: 'Img',
        Width: 200,
        Name: 'sImage5',
        Align: 'Center'
      },
      {
        Header: '6팀',
        Type: 'Img',
        Width: 200,
        Name: 'sImage6',
        Align: 'Center'
      },
      {
        Header: '7팀',
        Type: 'Img',
        Width: 200,
        Name: 'sImage7',
        Align: 'Center'
      },
      {
        Header: '8팀',
        Type: 'Img',
        Width: 200,
        Name: 'sImage8',
        Align: 'Center'
      }
    ]
  },

  // 버튼/기능 영역 html (sampleBtn으로 호출하면 action함수로 연결)
  func: '<div></div>',

  // 객체 생성 Html
  objEl: '<div id=\'sheetDiv\' style=\'width:100%;height:100%\'></div>',

  // 시트 하단 영역 html
  footer: '<span></span>',

  // 객체 생성 구문
  create: function () {
    var options = this.init;

    options.Events = this.event;
    IBSheet.create({
      id: 'sheet', // 생성할 시트의 id
      el: 'sheetDiv', // 시트를 생성할 Dom 객체 및 id
      options: options, // 생성될 시트의 속성
      data: this.data // 생성될 시트의 정적데이터
    });
  },

  // 버튼 클릭시 기능 로직
  action: function () {
  },

  // event구문
  event: {
    onStartDragCell: function (evtParam) {
      console.log(`${evtParam.eventName} 발생`);
      // sImage1 컬럼으로 이동하는 경우 return true
      if (evtParam.col === 'sImage1') {
        sheet.showMessageTime('1팀은 이동할 수 없습니다.', 800);

        return true;
      }
    },
    onEndDragCell: function (evtParam) {
      console.log(`${evtParam.eventName} 발생`);

      var bValue = evtParam.tosheet.getValue(evtParam.torow, evtParam.tocol);
      var aValue = evtParam.sheet.getValue(evtParam.row, evtParam.col);

      // sImage1 컬럼으로 이동하는 경우 return
      if (!evtParam.torow) { return; }
      if (evtParam.tocol === 'sImage1') {
        sheet.showMessageTime('1팀은 이동할 수 없습니다.', 800);

        return;
      }
      if (evtParam.tosheet && evtParam.torow && evtParam.tocol) {
        evtParam.tosheet.setValue(evtParam.torow, evtParam.tocol, aValue);

        if (bValue) {
          evtParam.sheet.setValue(evtParam.row, evtParam.col, bValue);
        } else {
          evtParam.sheet.setValue(evtParam.row, evtParam.col, '');
        }
      }
    }
  },

  // data
  data: [
    {
      sImage1: '|../assets/imgs/11/s1.jpg|80|100|||',
      sImage2: '|../assets/imgs/11/s3.jpg|80|100|||',
      sImage3: '|../assets/imgs/11/s5.jpg|80|100|||',
      sImage4: '|../assets/imgs/11/s7.jpg|80|100|||',
      sImage5: '|../assets/imgs/11/s9.jpg|80|100|||',
      sImage6: '|../assets/imgs/11/s11.jpg|80|100|||',
      sImage7: '|../assets/imgs/11/s13.jpg|80|100|||',
      sImage8: '|../assets/imgs/11/s15.jpg|80|100|||'
    },
    {
      sImage1: '|../assets/imgs/11/s2.jpg|80|100|||',
      sImage2: '|../assets/imgs/11/s4.jpg|80|100|||',
      sImage3: '|../assets/imgs/11/s6.jpg|80|100|||',
      sImage4: '|../assets/imgs/11/s8.jpg|80|100|||',
      sImage5: '|../assets/imgs/11/s10.jpg|80|100|||',
      sImage6: '|../assets/imgs/11/s12.jpg|80|100|||',
      sImage7: '|../assets/imgs/11/s14.jpg|80|100|||',
      sImage8: '|../assets/imgs/11/s16.jpg|80|100|||'
    },
    {
      sImage1: '|../assets/imgs/11/s17.jpg|80|100|||',
      sImage2: '|../assets/imgs/11/s19.jpg|80|100|||',
      sImage3: '|../assets/imgs/11/s21.jpg|80|100|||',
      sImage4: '|../assets/imgs/11/s23.jpg|80|100|||',
      sImage5: '|../assets/imgs/11/s25.jpg|80|100|||',
      sImage6: '|../assets/imgs/11/s27.jpg|80|100|||',
      sImage7: '|../assets/imgs/11/s29.jpg|80|100|||'
    },
    {
      sImage1: '|../assets/imgs/11/s18.jpg|80|100|||',
      sImage2: '|../assets/imgs/11/s20.jpg|80|100|||',
      sImage3: '|../assets/imgs/11/s22.jpg|80|100|||',
      sImage4: '|../assets/imgs/11/s24.jpg|80|100|||',
      sImage5: '|../assets/imgs/11/s26.jpg|80|100|||',
      sImage6: '|../assets/imgs/11/s28.jpg|80|100|||',
      sImage7: '|../assets/imgs/11/s30.jpg|80|100|||'
    }
  ]
};

var sampleBtn = function () {
  var args = Array.prototype.slice.call(arguments, 0);

  samplePageObj.action.apply(null, args);
};
